# Altiq AutoFill - Browser Extension

A Chrome/Firefox browser extension that automatically fills web forms using AI-extracted data from your documents.

User guide:
- `docs/USER_GUIDE.md`

## Features

- 🤖 **AI-Powered Field Detection**: Automatically detects and categorizes form fields
- 🎯 **Smart Matching**: Uses vector search to match form fields with your stored data
- 🎨 **Confidence Visualization**: Color-coded fields (green/orange/red) based on confidence
- 📚 **Learning from Corrections**: Improves accuracy by learning from user corrections
- 🔒 **Secure**: JWT authentication with encrypted token storage
- ⚡ **Fast**: Instant auto-fill with cached data

## Installation

### Chrome

1. Open Chrome and navigate to `chrome://extensions/`
2. Enable "Developer mode" (toggle in top right)
3. Click "Load unpacked"
4. Select the `/opt/aura/altiq-autofill/extension` directory
5. The Altiq AutoFill icon should appear in your toolbar

### Firefox

1. Open Firefox and navigate to `about:debugging#/runtime/this-firefox`
2. Click "Load Temporary Add-on"
3. Navigate to `/opt/aura/altiq-autofill/extension` and select `manifest.json`
4. The extension will be loaded temporarily

## Usage

### First Time Setup

1. Click the Altiq AutoFill icon in your browser toolbar
2. Create an account or sign in
3. Upload your documents (resume, tax forms, etc.) through the backend API
4. The extension will extract and store your information

### Auto-Filling Forms

1. Navigate to any web page with a form
2. Click the Altiq AutoFill icon and click "AutoFill This Page"
3. The extension will:
   - Detect all fillable fields
   - Match them with your stored data
   - Fill the fields with color-coded confidence:
     - 🟢 **Green**: High confidence (≥80%)
     - 🟠 **Orange**: Medium confidence (50-79%)
     - 🔴 **Red**: Low confidence (<50%)

### Learning from Corrections

If a field is filled incorrectly:
1. Simply correct the value manually
2. The extension will automatically learn from your correction
3. Future forms will use the corrected value with high confidence

## Field Detection

The extension automatically detects:

- Email addresses
- Phone numbers
- Names (first, last, full)
- Addresses (street, city, state, zip, country)
- Social Security Numbers
- Date of birth
- Company/Organization
- Position/Job title
- Websites/URLs

## Configuration

Use the extension Options page to select the API environment (Production / Development / Local).

## File Structure

```
extension/
├── manifest.json          # Extension configuration
├── popup.html            # Extension popup UI
├── popup.js              # Popup logic and authentication
├── content.js            # Content script for field detection and filling
├── content.css           # Styles for autofilled fields
├── background.js         # Background service worker
├── icons/                # Extension icons (16x16, 48x48, 128x128)
└── README.md            # This file
```

## API Integration

The extension communicates with the backend API:

- `POST /api/v1/auth/login` - Sign in

Primary endpoints used by the current extension:
- `GET /api/v1/autofill/context` - Get hostname context
- `PUT /api/v1/autofill/context` - Update hostname context
- `POST /api/v1/autofill/map-fields` - Compute fill plan

Additional service endpoints:
- `POST /api/v1/auth/login` - JWT sign-in (when used)
- `POST /api/v1/documents/upload` - Upload documents (typically via admin)

## Development

### Testing

1. Make changes to the extension files
2. Go to `chrome://extensions/` (or `about:debugging` in Firefox)
3. Click the "Reload" button for Altiq AutoFill
4. Test on a form page

### Debugging

- **Popup**: Right-click the extension icon → "Inspect popup"
- **Content Script**: Open DevTools on any page and check console
- **Background**: Go to `chrome://extensions/` → "Inspect views: background page"

## Security

- Tokens are stored securely in Chrome's local storage
- API communication uses HTTPS in production
- Passwords are never stored in the extension
- All sensitive data is encrypted in transit

## Known Limitations

- Requires backend API to be running
- Some dynamically loaded forms may need page refresh
- Complex multi-step forms may require manual intervention
- Vector search requires Qdrant to be running (graceful fallback available)

## Future Enhancements

- [ ] Support for more field types (credit cards, passport, etc.)
- [ ] Multi-language support
- [ ] Form templates for common sites
- [ ] Keyboard shortcuts
- [ ] Field preview before filling
- [ ] Export/import user data
- [ ] Firefox full support (currently Chrome-optimized)

## License

Proprietary - Altiq AutoFill SaaS

## Support

For issues or questions, contact support@altiq.io
